var gulp  = require('gulp'),
    concat = require('gulp-concat'),
    inject = require('gulp-inject'),
    cssmin = require('gulp-cssmin'),
    uglify = require('gulp-uglify');

var pkg = require('./package.json');
var fileName = pkg.name+"-"+pkg.version+".min.js";

gulp.task("minjs", function(){
  return gulp.src("./src/scripts/*.js")
    .pipe(concat(fileName))
    .pipe(uglify())
    .pipe(gulp.dest("./dist/lib"));
});

gulp.task("mincss", function(){
  return gulp.src("./src/css/*.css")
    .pipe(concat("styles.css"))
    .pipe(cssmin())
    .pipe(gulp.dest("./dist/lib"));
});

gulp.task("inject",["minjs","mincss"], function(){
  return gulp.src("./src/index.html")
    .pipe(inject(gulp.src(["./dist/lib/*.js","./dist/lib/*.css"]),
        {ignorePath: 'dist'}))
    .pipe(gulp.dest("./dist"));
});

gulp.task("default", ["inject"]);
